package keyvault

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// MHSMPrivateEndpointConnectionsClient is the the Azure management API provides a RESTful set of web services that
// interact with Azure Key Vault.
type MHSMPrivateEndpointConnectionsClient struct {
	BaseClient
}

// NewMHSMPrivateEndpointConnectionsClient creates an instance of the MHSMPrivateEndpointConnectionsClient client.
func NewMHSMPrivateEndpointConnectionsClient(subscriptionID string) MHSMPrivateEndpointConnectionsClient {
	return NewMHSMPrivateEndpointConnectionsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewMHSMPrivateEndpointConnectionsClientWithBaseURI creates an instance of the MHSMPrivateEndpointConnectionsClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewMHSMPrivateEndpointConnectionsClientWithBaseURI(baseURI string, subscriptionID string) MHSMPrivateEndpointConnectionsClient {
	return MHSMPrivateEndpointConnectionsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Delete deletes the specified private endpoint connection associated with the managed hsm pool.
// Parameters:
// resourceGroupName - name of the resource group that contains the managed HSM pool.
// name - name of the managed HSM Pool
// privateEndpointConnectionName - name of the private endpoint connection associated with the managed hsm
// pool.
func (client MHSMPrivateEndpointConnectionsClient) Delete(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result MHSMPrivateEndpointConnectionsDeleteFuture, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MHSMPrivateEndpointConnectionsClient.Delete")
		defer func() {
			sc := -1
			if result.FutureAPI != nil && result.FutureAPI.Response() != nil {
				sc = result.FutureAPI.Response().StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, resourceGroupName, name, privateEndpointConnectionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "Delete", nil, "Failure preparing request")
		return
	}

	result, err = client.DeleteSender(req)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "Delete", result.Response(), "Failure sending request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client MHSMPrivateEndpointConnectionsClient) DeletePreparer(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                          autorest.Encode("path", name),
		"privateEndpointConnectionName": autorest.Encode("path", privateEndpointConnectionName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/privateEndpointConnections/{privateEndpointConnectionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client MHSMPrivateEndpointConnectionsClient) DeleteSender(req *http.Request) (future MHSMPrivateEndpointConnectionsDeleteFuture, err error) {
	var resp *http.Response
	future.FutureAPI = &azure.Future{}
	resp, err = client.Send(req, azure.DoRetryWithRegistration(client.Client))
	if err != nil {
		return
	}
	var azf azure.Future
	azf, err = azure.NewFutureFromResponse(resp)
	future.FutureAPI = &azf
	future.Result = future.result
	return
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client MHSMPrivateEndpointConnectionsClient) DeleteResponder(resp *http.Response) (result MHSMPrivateEndpointConnection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted, http.StatusNoContent),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get gets the specified private endpoint connection associated with the managed HSM Pool.
// Parameters:
// resourceGroupName - name of the resource group that contains the managed HSM pool.
// name - name of the managed HSM Pool
// privateEndpointConnectionName - name of the private endpoint connection associated with the managed hsm
// pool.
func (client MHSMPrivateEndpointConnectionsClient) Get(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (result MHSMPrivateEndpointConnection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MHSMPrivateEndpointConnectionsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, resourceGroupName, name, privateEndpointConnectionName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client MHSMPrivateEndpointConnectionsClient) GetPreparer(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                          autorest.Encode("path", name),
		"privateEndpointConnectionName": autorest.Encode("path", privateEndpointConnectionName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/privateEndpointConnections/{privateEndpointConnectionName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client MHSMPrivateEndpointConnectionsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client MHSMPrivateEndpointConnectionsClient) GetResponder(resp *http.Response) (result MHSMPrivateEndpointConnection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResource the List operation gets information about the private endpoint connections associated with the
// managed HSM Pool.
// Parameters:
// resourceGroupName - name of the resource group that contains the managed HSM pool.
// name - name of the managed HSM Pool
func (client MHSMPrivateEndpointConnectionsClient) ListByResource(ctx context.Context, resourceGroupName string, name string) (result MHSMPrivateEndpointConnectionsListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MHSMPrivateEndpointConnectionsClient.ListByResource")
		defer func() {
			sc := -1
			if result.mpeclr.Response.Response != nil {
				sc = result.mpeclr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listByResourceNextResults
	req, err := client.ListByResourcePreparer(ctx, resourceGroupName, name)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "ListByResource", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListByResourceSender(req)
	if err != nil {
		result.mpeclr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "ListByResource", resp, "Failure sending request")
		return
	}

	result.mpeclr, err = client.ListByResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "ListByResource", resp, "Failure responding to request")
		return
	}
	if result.mpeclr.hasNextLink() && result.mpeclr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListByResourcePreparer prepares the ListByResource request.
func (client MHSMPrivateEndpointConnectionsClient) ListByResourcePreparer(ctx context.Context, resourceGroupName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":              autorest.Encode("path", name),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/privateEndpointConnections", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListByResourceSender sends the ListByResource request. The method will close the
// http.Response Body if it receives an error.
func (client MHSMPrivateEndpointConnectionsClient) ListByResourceSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListByResourceResponder handles the response to the ListByResource request. The method always
// closes the http.Response Body.
func (client MHSMPrivateEndpointConnectionsClient) ListByResourceResponder(resp *http.Response) (result MHSMPrivateEndpointConnectionsListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listByResourceNextResults retrieves the next set of results, if any.
func (client MHSMPrivateEndpointConnectionsClient) listByResourceNextResults(ctx context.Context, lastResults MHSMPrivateEndpointConnectionsListResult) (result MHSMPrivateEndpointConnectionsListResult, err error) {
	req, err := lastResults.mHSMPrivateEndpointConnectionsListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "listByResourceNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListByResourceSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "listByResourceNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListByResourceResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "listByResourceNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListByResourceComplete enumerates all values, automatically crossing page boundaries as required.
func (client MHSMPrivateEndpointConnectionsClient) ListByResourceComplete(ctx context.Context, resourceGroupName string, name string) (result MHSMPrivateEndpointConnectionsListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MHSMPrivateEndpointConnectionsClient.ListByResource")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListByResource(ctx, resourceGroupName, name)
	return
}

// Put updates the specified private endpoint connection associated with the managed hsm pool.
// Parameters:
// resourceGroupName - name of the resource group that contains the managed HSM pool.
// name - name of the managed HSM Pool
// privateEndpointConnectionName - name of the private endpoint connection associated with the managed hsm
// pool.
// properties - the intended state of private endpoint connection.
func (client MHSMPrivateEndpointConnectionsClient) Put(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, properties MHSMPrivateEndpointConnection) (result MHSMPrivateEndpointConnection, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/MHSMPrivateEndpointConnectionsClient.Put")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.PutPreparer(ctx, resourceGroupName, name, privateEndpointConnectionName, properties)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "Put", nil, "Failure preparing request")
		return
	}

	resp, err := client.PutSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "Put", resp, "Failure sending request")
		return
	}

	result, err = client.PutResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "keyvault.MHSMPrivateEndpointConnectionsClient", "Put", resp, "Failure responding to request")
		return
	}

	return
}

// PutPreparer prepares the Put request.
func (client MHSMPrivateEndpointConnectionsClient) PutPreparer(ctx context.Context, resourceGroupName string, name string, privateEndpointConnectionName string, properties MHSMPrivateEndpointConnection) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"name":                          autorest.Encode("path", name),
		"privateEndpointConnectionName": autorest.Encode("path", privateEndpointConnectionName),
		"resourceGroupName":             autorest.Encode("path", resourceGroupName),
		"subscriptionId":                autorest.Encode("path", client.SubscriptionID),
	}

	const APIVersion = "2021-11-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/managedHSMs/{name}/privateEndpointConnections/{privateEndpointConnectionName}", pathParameters),
		autorest.WithJSON(properties),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// PutSender sends the Put request. The method will close the
// http.Response Body if it receives an error.
func (client MHSMPrivateEndpointConnectionsClient) PutSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// PutResponder handles the response to the Put request. The method always
// closes the http.Response Body.
func (client MHSMPrivateEndpointConnectionsClient) PutResponder(resp *http.Response) (result MHSMPrivateEndpointConnection, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
