package backup

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// ResourceGuardProxiesClient is the open API 2.0 Specs for Azure RecoveryServices Backup service
type ResourceGuardProxiesClient struct {
	BaseClient
}

// NewResourceGuardProxiesClient creates an instance of the ResourceGuardProxiesClient client.
func NewResourceGuardProxiesClient(subscriptionID string) ResourceGuardProxiesClient {
	return NewResourceGuardProxiesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewResourceGuardProxiesClientWithBaseURI creates an instance of the ResourceGuardProxiesClient client using a custom
// endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure
// stack).
func NewResourceGuardProxiesClientWithBaseURI(baseURI string, subscriptionID string) ResourceGuardProxiesClient {
	return ResourceGuardProxiesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get list the ResourceGuardProxies under vault
// Parameters:
// vaultName - the name of the recovery services vault.
// resourceGroupName - the name of the resource group where the recovery services vault is present.
func (client ResourceGuardProxiesClient) Get(ctx context.Context, vaultName string, resourceGroupName string) (result ResourceGuardProxyBaseResourceListPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardProxiesClient.Get")
		defer func() {
			sc := -1
			if result.rgpbrl.Response.Response != nil {
				sc = result.rgpbrl.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.getNextResults
	req, err := client.GetPreparer(ctx, vaultName, resourceGroupName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "backup.ResourceGuardProxiesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.rgpbrl.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "backup.ResourceGuardProxiesClient", "Get", resp, "Failure sending request")
		return
	}

	result.rgpbrl, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "backup.ResourceGuardProxiesClient", "Get", resp, "Failure responding to request")
		return
	}
	if result.rgpbrl.hasNextLink() && result.rgpbrl.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client ResourceGuardProxiesClient) GetPreparer(ctx context.Context, vaultName string, resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"vaultName":         autorest.Encode("path", vaultName),
	}

	const APIVersion = "2021-07-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.RecoveryServices/vaults/{vaultName}/backupResourceGuardProxies", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceGuardProxiesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ResourceGuardProxiesClient) GetResponder(resp *http.Response) (result ResourceGuardProxyBaseResourceList, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// getNextResults retrieves the next set of results, if any.
func (client ResourceGuardProxiesClient) getNextResults(ctx context.Context, lastResults ResourceGuardProxyBaseResourceList) (result ResourceGuardProxyBaseResourceList, err error) {
	req, err := lastResults.resourceGuardProxyBaseResourceListPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "backup.ResourceGuardProxiesClient", "getNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "backup.ResourceGuardProxiesClient", "getNextResults", resp, "Failure sending next results request")
	}
	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "backup.ResourceGuardProxiesClient", "getNextResults", resp, "Failure responding to next results request")
	}
	return
}

// GetComplete enumerates all values, automatically crossing page boundaries as required.
func (client ResourceGuardProxiesClient) GetComplete(ctx context.Context, vaultName string, resourceGroupName string) (result ResourceGuardProxyBaseResourceListIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/ResourceGuardProxiesClient.Get")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.Get(ctx, vaultName, resourceGroupName)
	return
}
