package csscolorparser

import "testing"

func TestBrowserFirefox(t *testing.T) {
	type testData struct {
		colorStr   string
		r, g, b, a uint8
	}
	// Randomly generated color string, parsed using Mozilla Firefox 84.0.2
	data := []testData{
		{"#817801", 129, 120, 1, 255},
		{"#62D5", 102, 34, 221, 85},
		{"#857D", 136, 85, 119, 221},
		{"#8D0C5BBE", 141, 12, 91, 190},
		{"#BD5", 187, 221, 85, 255},
		{"#A64", 170, 102, 68, 255},
		{"#8092", 136, 0, 153, 34},
		{"#1C0FF87B", 28, 15, 248, 123},
		{"#818FFE", 129, 143, 254, 255},
		{"#1ed0ebea", 30, 208, 235, 234},
		{"#0D5FCA67", 13, 95, 202, 103},
		{"#C285F3", 194, 133, 243, 255},
		{"#7D0D", 119, 221, 0, 221},
		{"#E30", 238, 51, 0, 255},
		{"#6e5dc4", 110, 93, 196, 255},
		{"#389A", 51, 136, 153, 170},
		{"#F1D", 255, 17, 221, 255},
		{"#8BB5", 136, 187, 187, 85},
		{"#3DAA", 51, 221, 170, 170},
		{"#B1D88F42", 177, 216, 143, 66},
		{"#793", 119, 153, 51, 255},
		{"#55da", 85, 85, 221, 170},
		{"#BE70C687", 190, 112, 198, 135},
		{"#4FD", 68, 255, 221, 255},
		{"#30D38748", 48, 211, 135, 72},
		{"#878", 136, 119, 136, 255},
		{"#AC0D", 170, 204, 0, 221},
		{"#12E", 17, 34, 238, 255},
		{"#0DD3", 0, 221, 221, 51},
		{"#7F54C08F", 127, 84, 192, 143},
		{"#6cc7cba0", 108, 199, 203, 160},
		{"#E97933", 233, 121, 51, 255},
		{"#9237", 153, 34, 51, 119},
		{"#F1FB94BD", 241, 251, 148, 189},
		{"#9a8", 153, 170, 136, 255},
		{"#0fcb7f03", 15, 203, 127, 3},
		{"#534603AF", 83, 70, 3, 175},
		{"#ef4cfc11", 239, 76, 252, 17},
		{"#5D16052C", 93, 22, 5, 44},
		{"#090", 0, 153, 0, 255},
		{"#bc1f653a", 188, 31, 101, 58},
		{"#ED02A8", 237, 2, 168, 255},
		{"#6dc", 102, 221, 204, 255},
		{"#E2E9", 238, 34, 238, 153},
		{"#77B69060", 119, 182, 144, 96},
		{"#0953FC", 9, 83, 252, 255},
		{"#09C", 0, 153, 204, 255},
		{"#172aca", 23, 42, 202, 255},
		{"#74c18f04", 116, 193, 143, 4},
		{"#153B", 17, 85, 51, 187},
		{"rgb(264.654,8.955,5.446)", 255, 9, 5, 255},
		{"rgb(63.688,192.702,251.174,0.322)", 64, 193, 251, 82},
		{"rgb(131.708,39.654,79.812,1.128)", 132, 40, 80, 255},
		{"rgb(116.842,105.189,171.013)", 117, 105, 171, 255},
		{"rgb(120.525,88.804,130.411,0.946)", 121, 89, 130, 241},
		{"rgb(240.988,49.789,222.272,0.325)", 241, 50, 222, 83},
		{"rgb(187.245,215.507,159.236)", 187, 216, 159, 255},
		{"rgb(98.714,205.689,261.942)", 99, 206, 255, 255},
		{"rgb(209.553,174.927,193.981)", 210, 175, 194, 255},
		{"rgb(7.372,4.253,86.174,0.041)", 7, 4, 86, 10},
		{"rgb(150.202,78.032,213.103,0.337)", 150, 78, 213, 86},
		{"rgb(246.369,62.382,31.651)", 246, 62, 32, 255},
		{"rgb(236.566,160.563,89.892)", 237, 161, 90, 255},
		{"rgb(112.356,163.535,102.720,-0.042)", 112, 164, 103, 0},
		{"rgb(35.219,244.481,202.782,0.493)", 35, 244, 203, 126},
		{"rgb(232.189,255.053,111.323)", 232, 255, 111, 255},
		{"rgb(109.771,118.748,181.671)", 110, 119, 182, 255},
		{"rgb(92.105,105.280,144.175)", 92, 105, 144, 255},
		{"rgb(18.643,213.863,186.733)", 19, 214, 187, 255},
		{"rgb(3.754,214.128,20.735,1.158)", 4, 214, 21, 255},
		{"rgb(234.259,224.675,206.049)", 234, 225, 206, 255},
		{"rgb(-7.668,131.621,160.351,0.411)", 0, 132, 160, 105},
		{"rgb(45.824,242.113,209.576)", 46, 242, 210, 255},
		{"rgb(30.113,222.102,93.192)", 30, 222, 93, 255},
		{"rgb(245.402,199.722,-8.903)", 245, 200, 0, 255},
		{"rgb(106.884,234.873,44.912,0.572)", 107, 235, 45, 146},
		{"rgb(76.730,168.471,90.981)", 77, 168, 91, 255},
		{"rgb(197.334,-0.665,134.907,0.421)", 197, 0, 135, 107},
		{"rgb(120.677,48.776,120.922)", 121, 49, 121, 255},
		{"rgb(165.450,89.865,211.876)", 165, 90, 212, 255},
		{"rgb(88.649,20.622,250.829)", 89, 21, 251, 255},
		{"rgb(-3.239,112.321,33.676)", 0, 112, 34, 255},
		{"rgb(211.846,130.462,175.005)", 212, 130, 175, 255},
		{"rgb(154.051,122.824,-9.377)", 154, 123, 0, 255},
		{"rgb(144.666,79.334,20.699,0.412)", 145, 79, 21, 105},
		{"rgb(234.323,96.841,102.930,0.187)", 234, 97, 103, 48},
		{"rgb(196.469,255.522,21.318,0.300)", 196, 255, 21, 77},
		{"rgb(23.779,145.864,206.664)", 24, 146, 207, 255},
		{"rgb(133.613,9.608,39.029)", 134, 10, 39, 255},
		{"rgb(218.954,163.743,79.818)", 219, 164, 80, 255},
		{"rgb(33.108,151.645,11.619,1.132)", 33, 152, 12, 255},
		{"rgb(204.629,39.956,-4.544)", 205, 40, 0, 255},
		{"rgb(123.245,255.852,24.856)", 123, 255, 25, 255},
		{"rgb(90.894,-2.651,116.502,0.596)", 91, 0, 117, 152},
		{"rgb(79.128,115.857,155.230)", 79, 116, 155, 255},
		{"rgb(87.319,70.167,172.069,-0.033)", 87, 70, 172, 0},
		{"rgb(48.049,235.369,171.190,0.534)", 48, 235, 171, 136},
		{"rgb(15.808,223.023,81.102,-0.116)", 16, 223, 81, 0},
		{"rgb(255.282,239.066,222.922)", 255, 239, 223, 255},
		{"rgb(173.178,-7.708,29.095,1.177)", 173, 0, 29, 255},
		{"rgb(-5.791%,-7.797%,44.772%)", 0, 0, 114, 255},
		{"rgb(103.362%,86.514%,79.870%,0.467)", 255, 221, 204, 119},
		{"rgb(79.920%,30.359%,66.318%)", 204, 77, 169, 255},
		{"rgb(54.309%,48.762%,42.059%)", 138, 124, 107, 255},
		{"rgb(89.114%,50.975%,80.230%,0.843)", 227, 130, 205, 215},
		{"rgb(-2.707%,3.715%,26.256%,0.185)", 0, 9, 67, 47},
		{"rgb(51.827%,102.172%,-0.876%,0.302)", 132, 255, 0, 77},
		{"rgb(14.092%,63.162%,97.286%)", 36, 161, 248, 255},
		{"rgb(20.757%,33.676%,26.518%)", 53, 86, 68, 255},
		{"rgb(85.387%,32.861%,29.168%)", 218, 84, 74, 255},
		{"rgb(20.322%,107.488%,-9.083%)", 52, 255, 0, 255},
		{"rgb(9.805%,12.717%,78.073%)", 25, 32, 199, 255},
		{"rgb(80.225%,-7.567%,91.104%)", 205, 0, 232, 255},
		{"rgb(57.826%,66.957%,35.887%)", 147, 171, 92, 255},
		{"rgb(-5.675%,36.883%,86.567%)", 0, 94, 221, 255},
		{"rgb(96.884%,-7.570%,86.334%,0.539)", 247, 0, 220, 137},
		{"rgb(109.872%,32.523%,-3.411%,1.081)", 255, 83, 0, 255},
		{"rgb(31.101%,2.122%,41.198%)", 79, 5, 105, 255},
		{"rgb(15.290%,88.533%,91.984%)", 39, 226, 235, 255},
		{"rgb(43.254%,59.929%,88.796%)", 110, 153, 226, 255},
		{"rgb(20.849%,65.810%,108.952%)", 53, 168, 255, 255},
		{"rgb(107.764%,106.729%,5.219%,0.722)", 255, 255, 13, 184},
		{"rgb(87.428%,12.272%,55.687%)", 223, 31, 142, 255},
		{"rgb(66.030%,91.694%,36.578%)", 168, 234, 93, 255},
		{"rgb(50.947%,70.496%,90.525%)", 130, 180, 231, 255},
		{"rgb(20.316%,98.256%,21.624%)", 52, 251, 55, 255},
		{"rgb(101.253%,97.684%,18.923%,0.982)", 255, 249, 48, 250},
		{"rgb(73.848%,64.384%,24.685%)", 188, 164, 63, 255},
		{"rgb(106.833%,104.707%,97.097%)", 255, 255, 248, 255},
		{"rgb(0.219%,58.327%,64.714%)", 1, 149, 165, 255},
		{"rgb(105.545%,54.528%,72.587%)", 255, 139, 185, 255},
		{"rgb(15.832%,89.520%,67.361%)", 40, 228, 172, 255},
		{"rgb(99.044%,-8.225%,107.718%,0.707)", 253, 0, 255, 180},
		{"rgb(53.693%,23.908%,60.057%,-0.168)", 137, 61, 153, 0},
		{"rgb(79.097%,41.894%,91.880%)", 202, 107, 234, 255},
		{"rgb(75.495%,78.770%,40.656%,0.394)", 193, 201, 104, 100},
		{"rgb(98.775%,87.084%,9.632%)", 252, 222, 25, 255},
		{"rgb(7.499%,58.822%,37.091%,0.211)", 19, 150, 95, 54},
		{"rgb(53.511%,45.547%,31.029%)", 136, 116, 79, 255},
		{"rgb(103.106%,79.057%,60.671%)", 255, 202, 155, 255},
		{"rgb(44.343%,52.743%,100.265%,-0.047)", 113, 134, 255, 0},
		{"rgb(109.647%,58.782%,0.907%,0.718)", 255, 150, 2, 183},
		{"rgb(24.882%,96.959%,43.001%,0.400)", 63, 247, 110, 102},
		{"rgb(74.362%,41.983%,9.375%)", 190, 107, 24, 255},
		{"rgb(46.816%,66.074%,108.821%)", 119, 168, 255, 255},
		{"rgb(77.497%,89.829%,62.736%,-0.026)", 198, 229, 160, 0},
		{"rgb(26.042%,65.488%,69.547%,0.348)", 66, 167, 177, 89},
		{"rgb(23.342%,-0.633%,77.730%)", 60, 0, 198, 255},
		{"rgb(33.015%,81.191%,78.615%)", 84, 207, 200, 255},
		{"rgb(108.596%,93.998%,0.798%)", 255, 240, 2, 255},
		{"hsl(237.711grad,88.536%,36.402%)", 11, 82, 175, 255},
		{"hsl(281.434,105.519%,-5.626%)", 0, 0, 0, 255},
		{"hsl(257.634deg,91.970%,34.848%)", 55, 7, 171, 255},
		{"hsl(0.944turn,70.481%,50.217%)", 218, 39, 99, 255},
		{"hsl(327.085deg,22.465%,-2.142%,-0.156)", 0, 0, 0, 0},
		{"hsl(366.588deg,62.880%,50.057%,0.213)", 208, 65, 48, 54},
		{"hsl(34.042,89.193%,33.385%)", 161, 95, 9, 255},
		{"hsl(359.760,66.421%,97.192%)", 253, 243, 243, 255},
		{"hsl(3.111grad,106.058%,21.159%)", 108, 5, 0, 255},
		{"hsl(0.918rad,-9.357%,33.825%)", 86, 86, 86, 255},
		{"hsl(37.202deg,96.433%,9.973%)", 50, 31, 1, 255},
		{"hsl(2.694rad,56.805%,80.396%)", 177, 233, 209, 255},
		{"hsl(369.063,52.881%,26.098%)", 102, 42, 31, 255},
		{"hsl(142.665,70.616%,96.183%)", 238, 252, 244, 255},
		{"hsl(266.585grad,98.461%,8.780%)", 0, 0, 44, 255},
		{"hsl(0.292turn,89.098%,25.780%)", 36, 124, 7, 255},
		{"hsl(-0.043turn,-9.603%,106.006%)", 255, 255, 255, 255},
		{"hsl(135.985deg,29.099%,103.419%)", 255, 255, 255, 255},
		{"hsl(293.828,52.597%,7.326%)", 26, 9, 29, 255},
		{"hsl(309.911grad,74.581%,0.263%)", 1, 0, 1, 255},
		{"hsl(1.676rad,91.390%,15.755%)", 33, 77, 3, 255},
		{"hsl(350.968deg,33.726%,88.331%,0.471)", 235, 215, 218, 120},
		{"hsl(353.287grad,-9.139%,89.568%)", 228, 228, 228, 255},
		{"hsl(2.953rad,52.179%,10.657%,0.989)", 13, 41, 36, 252},
		{"hsl(298.491,41.628%,64.058%)", 200, 125, 202, 255},
		{"hsl(0.840turn,89.447%,73.390%,0.161)", 248, 126, 243, 41},
		{"hsl(0.415turn,3.520%,74.963%)", 189, 193, 191, 255},
		{"hsl(309.723deg,-2.498%,81.780%)", 209, 209, 209, 255},
		{"hsl(346.595,27.379%,5.620%)", 18, 10, 12, 255},
		{"hsl(0.345turn,28.417%,71.498%)", 162, 203, 165, 255},
		{"hsl(-0.074turn,91.885%,16.669%)", 82, 3, 38, 255},
		{"hsl(154.320deg,-5.633%,-4.799%,-0.005)", 0, 0, 0, 0},
		{"hsl(5.983,-5.051%,50.117%)", 128, 128, 128, 255},
		{"hsl(78.942deg,93.449%,108.614%)", 255, 255, 255, 255},
		{"hsl(20.316deg,90.583%,20.504%)", 100, 37, 5, 255},
		{"hsl(231.054grad,63.039%,82.668%)", 183, 213, 239, 255},
		{"hsl(0.880turn,6.700%,10.668%)", 29, 25, 28, 255},
		{"hsl(37.954grad,79.594%,68.066%,-0.063)", 238, 183, 109, 0},
		{"hsl(193.327deg,59.120%,93.790%)", 230, 244, 249, 255},
		{"hsl(143.684deg,30.652%,82.141%)", 196, 223, 207, 255},
		{"hsl(134.726,4.308%,49.756%)", 121, 132, 124, 255},
		{"hsl(0.277turn,-7.056%,25.211%)", 64, 64, 64, 255},
		{"hsl(1.849deg,33.541%,58.253%,0.425)", 184, 115, 113, 108},
		{"hsl(151.147,86.285%,-6.549%)", 0, 0, 0, 255},
		{"hsl(0.226turn,107.942%,19.766%,0.533)", 65, 101, 0, 136},
		{"hsl(351.807deg,51.829%,70.431%,-0.069)", 219, 141, 151, 0},
		{"hsl(1.075turn,71.099%,71.695%)", 234, 178, 132, 255},
		{"hsl(235.353,50.281%,96.254%)", 241, 241, 250, 255},
		{"hsl(250.375deg,95.684%,91.300%)", 219, 212, 254, 255},
		{"hsl(0.579turn,76.129%,22.968%)", 14, 61, 103, 255},
	}
	for i, d := range data {
		c, err := Parse(d.colorStr)
		if err != nil {
			t.Errorf("Parse error: %s", d.colorStr)
			continue
		}
		r, g, b, a := c.RGBA255()
		rgba := [4]uint8{r, g, b, a}
		out := [4]uint8{d.r, d.g, d.b, d.a}
		if rgba != out {
			t.Errorf("(%d) %s -> %v != %v", i, d.colorStr, out, rgba)
		}
	}
}
